/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import sun.misc.Unsafe;
import sun.misc.VM;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.IOUtil;
import sun.security.action.GetPropertyAction;

public class Util {
    private static final int TEMP_BUF_POOL_SIZE = IOUtil.IOV_MAX;
    private static final long MAX_CACHED_BUFFER_SIZE = Util.getMaxCachedBufferSize();
    private static ThreadLocal<BufferCache> bufferCache = new ThreadLocal<BufferCache>(){

        @Override
        protected BufferCache initialValue() {
            return new BufferCache();
        }
    };
    private static Unsafe unsafe = Unsafe.getUnsafe();
    private static int pageSize = -1;
    private static volatile Constructor<?> directByteBufferConstructor = null;
    private static volatile Constructor<?> directByteBufferRConstructor = null;
    private static volatile String bugLevel = null;

    private static long getMaxCachedBufferSize() {
        String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("jdk.nio.maxCachedBufferSize");
            }
        });
        if (string != null) {
            try {
                long l = Long.parseLong(string);
                if (l >= 0L) {
                    return l;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Long.MAX_VALUE;
    }

    private static boolean isBufferTooLarge(int n) {
        return (long)n > MAX_CACHED_BUFFER_SIZE;
    }

    private static boolean isBufferTooLarge(ByteBuffer byteBuffer) {
        return Util.isBufferTooLarge(byteBuffer.capacity());
    }

    public static ByteBuffer getTemporaryDirectBuffer(int n) {
        if (Util.isBufferTooLarge(n)) {
            return ByteBuffer.allocateDirect(n);
        }
        BufferCache bufferCache = Util.bufferCache.get();
        ByteBuffer byteBuffer = bufferCache.get(n);
        if (byteBuffer != null) {
            return byteBuffer;
        }
        if (!bufferCache.isEmpty()) {
            byteBuffer = bufferCache.removeFirst();
            Util.free(byteBuffer);
        }
        return ByteBuffer.allocateDirect(n);
    }

    public static void releaseTemporaryDirectBuffer(ByteBuffer byteBuffer) {
        Util.offerFirstTemporaryDirectBuffer(byteBuffer);
    }

    static void offerFirstTemporaryDirectBuffer(ByteBuffer byteBuffer) {
        if (Util.isBufferTooLarge(byteBuffer)) {
            Util.free(byteBuffer);
            return;
        }
        assert (byteBuffer != null);
        BufferCache bufferCache = Util.bufferCache.get();
        if (!bufferCache.offerFirst(byteBuffer)) {
            Util.free(byteBuffer);
        }
    }

    static void offerLastTemporaryDirectBuffer(ByteBuffer byteBuffer) {
        if (Util.isBufferTooLarge(byteBuffer)) {
            Util.free(byteBuffer);
            return;
        }
        assert (byteBuffer != null);
        BufferCache bufferCache = Util.bufferCache.get();
        if (!bufferCache.offerLast(byteBuffer)) {
            Util.free(byteBuffer);
        }
    }

    private static void free(ByteBuffer byteBuffer) {
        ((DirectBuffer)((Object)byteBuffer)).cleaner().clean();
    }

    static ByteBuffer[] subsequence(ByteBuffer[] byteBufferArray, int n, int n2) {
        if (n == 0 && n2 == byteBufferArray.length) {
            return byteBufferArray;
        }
        int n3 = n2;
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[n3];
        for (int i = 0; i < n3; ++i) {
            byteBufferArray2[i] = byteBufferArray[n + i];
        }
        return byteBufferArray2;
    }

    static <E> Set<E> ungrowableSet(final Set<E> set) {
        return new Set<E>(){

            @Override
            public int size() {
                return set.size();
            }

            @Override
            public boolean isEmpty() {
                return set.isEmpty();
            }

            @Override
            public boolean contains(Object object) {
                return set.contains(object);
            }

            @Override
            public Object[] toArray() {
                return set.toArray();
            }

            @Override
            public <T> T[] toArray(T[] TArray) {
                return set.toArray(TArray);
            }

            public String toString() {
                return set.toString();
            }

            @Override
            public Iterator<E> iterator() {
                return set.iterator();
            }

            @Override
            public boolean equals(Object object) {
                return set.equals(object);
            }

            @Override
            public int hashCode() {
                return set.hashCode();
            }

            @Override
            public void clear() {
                set.clear();
            }

            @Override
            public boolean remove(Object object) {
                return set.remove(object);
            }

            @Override
            public boolean containsAll(Collection<?> collection) {
                return set.containsAll(collection);
            }

            @Override
            public boolean removeAll(Collection<?> collection) {
                return set.removeAll(collection);
            }

            @Override
            public boolean retainAll(Collection<?> collection) {
                return set.retainAll(collection);
            }

            @Override
            public boolean add(E e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends E> collection) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static byte _get(long l) {
        return unsafe.getByte(l);
    }

    private static void _put(long l, byte by) {
        unsafe.putByte(l, by);
    }

    static void erase(ByteBuffer byteBuffer) {
        unsafe.setMemory(((DirectBuffer)((Object)byteBuffer)).address(), byteBuffer.capacity(), (byte)0);
    }

    static Unsafe unsafe() {
        return unsafe;
    }

    static int pageSize() {
        if (pageSize == -1) {
            pageSize = Util.unsafe().pageSize();
        }
        return pageSize;
    }

    private static void initDBBConstructor() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    Class<?> clazz = Class.forName("java.nio.DirectByteBuffer");
                    Constructor<?> constructor = clazz.getDeclaredConstructor(Integer.TYPE, Long.TYPE, FileDescriptor.class, Runnable.class);
                    constructor.setAccessible(true);
                    directByteBufferConstructor = constructor;
                }
                catch (ClassCastException | ClassNotFoundException | IllegalArgumentException | NoSuchMethodException exception) {
                    throw new InternalError(exception);
                }
                return null;
            }
        });
    }

    static MappedByteBuffer newMappedByteBuffer(int n, long l, FileDescriptor fileDescriptor, Runnable runnable) {
        MappedByteBuffer mappedByteBuffer;
        if (directByteBufferConstructor == null) {
            Util.initDBBConstructor();
        }
        try {
            mappedByteBuffer = (MappedByteBuffer)directByteBufferConstructor.newInstance(new Integer(n), new Long(l), fileDescriptor, runnable);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
            throw new InternalError(reflectiveOperationException);
        }
        return mappedByteBuffer;
    }

    private static void initDBBRConstructor() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    Class<?> clazz = Class.forName("java.nio.DirectByteBufferR");
                    Constructor<?> constructor = clazz.getDeclaredConstructor(Integer.TYPE, Long.TYPE, FileDescriptor.class, Runnable.class);
                    constructor.setAccessible(true);
                    directByteBufferRConstructor = constructor;
                }
                catch (ClassCastException | ClassNotFoundException | IllegalArgumentException | NoSuchMethodException exception) {
                    throw new InternalError(exception);
                }
                return null;
            }
        });
    }

    static MappedByteBuffer newMappedByteBufferR(int n, long l, FileDescriptor fileDescriptor, Runnable runnable) {
        MappedByteBuffer mappedByteBuffer;
        if (directByteBufferRConstructor == null) {
            Util.initDBBRConstructor();
        }
        try {
            mappedByteBuffer = (MappedByteBuffer)directByteBufferRConstructor.newInstance(new Integer(n), new Long(l), fileDescriptor, runnable);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
            throw new InternalError(reflectiveOperationException);
        }
        return mappedByteBuffer;
    }

    static boolean atBugLevel(String string) {
        if (bugLevel == null) {
            if (!VM.isBooted()) {
                return false;
            }
            String string2 = AccessController.doPrivileged(new GetPropertyAction("sun.nio.ch.bugLevel"));
            bugLevel = string2 != null ? string2 : "";
        }
        return bugLevel.equals(string);
    }

    private static class BufferCache {
        private ByteBuffer[] buffers = new ByteBuffer[Util.access$000()];
        private int count;
        private int start;

        private int next(int n) {
            return (n + 1) % TEMP_BUF_POOL_SIZE;
        }

        BufferCache() {
        }

        ByteBuffer get(int n) {
            assert (!Util.isBufferTooLarge(n));
            if (this.count == 0) {
                return null;
            }
            ByteBuffer[] byteBufferArray = this.buffers;
            ByteBuffer byteBuffer = byteBufferArray[this.start];
            if (byteBuffer.capacity() < n) {
                ByteBuffer byteBuffer2;
                byteBuffer = null;
                int n2 = this.start;
                while ((n2 = this.next(n2)) != this.start && (byteBuffer2 = byteBufferArray[n2]) != null) {
                    if (byteBuffer2.capacity() < n) continue;
                    byteBuffer = byteBuffer2;
                    break;
                }
                if (byteBuffer == null) {
                    return null;
                }
                byteBufferArray[n2] = byteBufferArray[this.start];
            }
            byteBufferArray[this.start] = null;
            this.start = this.next(this.start);
            --this.count;
            byteBuffer.rewind();
            byteBuffer.limit(n);
            return byteBuffer;
        }

        boolean offerFirst(ByteBuffer byteBuffer) {
            assert (!Util.isBufferTooLarge(byteBuffer));
            if (this.count >= TEMP_BUF_POOL_SIZE) {
                return false;
            }
            this.start = (this.start + TEMP_BUF_POOL_SIZE - 1) % TEMP_BUF_POOL_SIZE;
            this.buffers[this.start] = byteBuffer;
            ++this.count;
            return true;
        }

        boolean offerLast(ByteBuffer byteBuffer) {
            assert (!Util.isBufferTooLarge(byteBuffer));
            if (this.count >= TEMP_BUF_POOL_SIZE) {
                return false;
            }
            int n = (this.start + this.count) % TEMP_BUF_POOL_SIZE;
            this.buffers[n] = byteBuffer;
            ++this.count;
            return true;
        }

        boolean isEmpty() {
            return this.count == 0;
        }

        ByteBuffer removeFirst() {
            assert (this.count > 0);
            ByteBuffer byteBuffer = this.buffers[this.start];
            this.buffers[this.start] = null;
            this.start = this.next(this.start);
            --this.count;
            return byteBuffer;
        }
    }
}

