/*
 * Decompiled with CFR 0.152.
 */
package com.testerum.report_server.service;

import com.testerum.report_server.config.ReportServerConfig;
import com.testerum.report_server.model.ReportInfo;
import com.testerum.report_server.service.GetReportsInfoService;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0012J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u000b\u001a\u00020\u0006H\u0012J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\r\u001a\u00020\u0006H\u0012\u00a8\u0006\u000e"}, d2={"Lcom/testerum/report_server/service/GetReportsInfoService;", "", "()V", "asUrlPath", "", "path", "Ljava/nio/file/Path;", "getReportsInfo", "", "Lcom/testerum/report_server/model/ReportInfo;", "getReportsInfoForProject", "projectDir", "getSubDirectories", "rootDirectory", "report-server-backend"})
public class GetReportsInfoService {
    @NotNull
    public List<ReportInfo> getReportsInfo() {
        Path reportsRootDirectory = ReportServerConfig.INSTANCE.getReportsRootDirectory();
        List projectDirs = this.getSubDirectories(reportsRootDirectory);
        boolean bl = false;
        List result = new ArrayList();
        for (Path projectDir : projectDirs) {
            List projectReportsInfo = this.getReportsInfoForProject(projectDir);
            result.addAll(projectReportsInfo);
        }
        return result;
    }

    private List<ReportInfo> getReportsInfoForProject(Path projectDir) {
        boolean bl = false;
        List result = new ArrayList();
        List environmentDirs = this.getSubDirectories(projectDir);
        for (Path envDir : environmentDirs) {
            String environmentWithProjectId = ((Object)envDir.getFileName()).toString();
            if (!StringsKt.contains$default((CharSequence)environmentWithProjectId, (CharSequence)"_ID_", (boolean)false, (int)2, null)) continue;
            String environmentName = StringsKt.substringBeforeLast$default((String)environmentWithProjectId, (String)"_ID_", null, (int)2, null);
            String projectId = StringsKt.substringAfter$default((String)environmentWithProjectId, (String)"_ID_", null, (int)2, null);
            Path statisticsReportPath = envDir.resolve("statistics.html");
            Path latestReportPath = envDir.resolve("latest-report.html");
            Path autoRefreshDashboardPath = envDir.resolve("autorefresh-dashboard.html");
            Path reportsRootDirectory = ReportServerConfig.INSTANCE.getReportsRootDirectory();
            String string = ((Object)projectDir.getFileName()).toString();
            Path path = reportsRootDirectory.relativize(statisticsReportPath);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"reportsRootDirectory.rel\u2026ize(statisticsReportPath)");
            String string2 = this.asUrlPath(path);
            Path path2 = reportsRootDirectory.relativize(latestReportPath);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"reportsRootDirectory.relativize(latestReportPath)");
            String string3 = this.asUrlPath(path2);
            Path path3 = reportsRootDirectory.relativize(autoRefreshDashboardPath);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"reportsRootDirectory.rel\u2026autoRefreshDashboardPath)");
            result.add(new ReportInfo(string, environmentName, projectId, string2, string3, this.asUrlPath(path3)));
        }
        return result;
    }

    private String asUrlPath(Path path) {
        StringBuilder url = new StringBuilder();
        for (Path pathPart : path) {
            url.append("/").append(((Object)pathPart).toString());
            String string = "pathPart = " + pathPart;
            boolean bl = false;
            System.out.println((Object)string);
        }
        String string = url.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.toString()");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Path> getSubDirectories(Path rootDirectory) {
        if (Files.notExists(rootDirectory, new LinkOption[0])) {
            return CollectionsKt.emptyList();
        }
        AutoCloseable autoCloseable = Files.walk(rootDirectory, 1, new FileVisitOption[0]);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Stream stream = (Stream)autoCloseable;
            boolean bl3 = false;
            Stream stream2 = stream.filter((Predicate)getSubDirectories.1.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue(stream2, (String)"stream\n                .filter { it.isDirectory }");
            List list = CollectionsKt.drop((Iterable)StreamsKt.toList(stream2), (int)1);
            return list;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }
}

