/*
 * Decompiled with CFR 0.152.
 */
package com.testerum.report_server.controller;

import com.testerum.logging.LoggerKt;
import com.testerum.report_server.controller.ReportController;
import com.testerum.report_server.model.ReportInfo;
import com.testerum.report_server.service.AddReportService;
import com.testerum.report_server.service.GetReportsInfoService;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/reports"}, produces={"application/json"})
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\nH\u0017J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/testerum/report_server/controller/ReportController;", "", "addReportService", "Lcom/testerum/report_server/service/AddReportService;", "getReportsInfoService", "Lcom/testerum/report_server/service/GetReportsInfoService;", "(Lcom/testerum/report_server/service/AddReportService;Lcom/testerum/report_server/service/GetReportsInfoService;)V", "addReport", "", "events", "", "getReportsInfo", "", "Lcom/testerum/report_server/model/ReportInfo;", "Companion", "report-server-backend"})
public class ReportController {
    private final AddReportService addReportService;
    private final GetReportsInfoService getReportsInfoService;
    private static final Logger LOGGER;
    @NotNull
    public static final Companion Companion;

    @GetMapping
    @NotNull
    public List<ReportInfo> getReportsInfo() {
        return this.getReportsInfoService.getReportsInfo();
    }

    @PostMapping
    public void addReport(@RequestBody @NotNull String events) {
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        LOGGER.info("Add Report endpoint was called");
        List eventsList = StringsKt.lines((CharSequence)events);
        this.addReportService.addReport(eventsList);
        LOGGER.info("Add Report endpoint has finsed");
    }

    public ReportController(@NotNull AddReportService addReportService, @NotNull GetReportsInfoService getReportsInfoService) {
        Intrinsics.checkNotNullParameter((Object)addReportService, (String)"addReportService");
        Intrinsics.checkNotNullParameter((Object)getReportsInfoService, (String)"getReportsInfoService");
        this.addReportService = addReportService;
        this.getReportsInfoService = getReportsInfoService;
    }

    static {
        Companion = new Companion(null);
        LOGGER = LoggerKt.getLogger((Object)Companion);
    }
}

