/*
 * Decompiled with CFR 0.152.
 */
package com.testerum.report_server.config;

import com.testerum.runner.events.model.ConfigurationEvent;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/testerum/report_server/config/ReportServerConfig;", "", "()V", "ENVIRONMENT_PROJECT_ID_SEPARATOR", "", "getReportPath", "Ljava/nio/file/Path;", "configEvent", "Lcom/testerum/runner/events/model/ConfigurationEvent;", "getReportsRootDirectory", "report-server-backend"})
public final class ReportServerConfig {
    @NotNull
    public static final String ENVIRONMENT_PROJECT_ID_SEPARATOR = "_ID_";
    @NotNull
    public static final ReportServerConfig INSTANCE;

    @NotNull
    public final Path getReportsRootDirectory() {
        Path path = Paths.get(System.getProperty("user.home"), new String[0]).resolve(".testerum").resolve("reports");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(System.getProp\u2026erum\").resolve(\"reports\")");
        return path;
    }

    @NotNull
    public final Path getReportPath(@NotNull ConfigurationEvent configEvent) {
        Intrinsics.checkNotNullParameter((Object)configEvent, (String)"configEvent");
        Path rootReportsDirectory = this.getReportsRootDirectory();
        String string = configEvent.getVariablesEnvironment();
        if (string == null) {
            string = "default-environment";
        }
        String executedEnvironment = string;
        String projectIdentifier = executedEnvironment + ENVIRONMENT_PROJECT_ID_SEPARATOR + configEvent.getProjectId();
        Path path = rootReportsDirectory.resolve(configEvent.getProjectName()).resolve(projectIdentifier);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"rootReportsDirectory.res\u2026esolve(projectIdentifier)");
        return path;
    }

    private ReportServerConfig() {
    }

    static {
        ReportServerConfig reportServerConfig;
        INSTANCE = reportServerConfig = new ReportServerConfig();
    }
}

