/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.jardiff;

import com.sun.applet2.preloader.CancelException;
import com.sun.deploy.jardiff.JarDiffConstants;
import com.sun.deploy.jardiff.Patcher;
import com.sun.deploy.resources.ResourceManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;

public class JarDiffPatcher
implements JarDiffConstants,
Patcher {
    private static final int DEFAULT_READ_SIZE = 2048;
    private byte[] newBytes = new byte[2048];

    public void applyPatch(Patcher.PatchDelegate patchDelegate, String string, String string2, OutputStream outputStream) throws IOException {
        Object object;
        File file = new File(string);
        File file2 = new File(string2);
        JarOutputStream jarOutputStream = new JarOutputStream(outputStream);
        JarFile jarFile = new JarFile(file);
        JarFile jarFile2 = new JarFile(file2);
        HashSet hashSet = new HashSet();
        HashMap hashMap = new HashMap();
        this.determineNameMapping(jarFile2, hashSet, hashMap);
        Object[] objectArray = hashMap.keySet().toArray();
        HashSet<String> hashSet2 = new HashSet<String>();
        Enumeration<JarEntry> enumeration = jarFile.entries();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                hashSet2.add(enumeration.nextElement().getName());
            }
        }
        double d = hashSet2.size() + objectArray.length + jarFile2.size();
        double d2 = 0.0;
        hashSet2.removeAll(hashSet);
        d -= (double)hashSet.size();
        Enumeration<JarEntry> enumeration2 = jarFile2.entries();
        if (enumeration2 != null) {
            while (enumeration2.hasMoreElements()) {
                JarEntry jarEntry = enumeration2.nextElement();
                if (!"META-INF/INDEX.JD".equals(jarEntry.getName())) {
                    this.updateDelegate(patchDelegate, d2, d);
                    d2 += 1.0;
                    this.writeEntry(jarOutputStream, jarEntry, jarFile2);
                    boolean bl = hashSet2.remove(jarEntry.getName());
                    if (!bl) continue;
                    d -= 1.0;
                    continue;
                }
                d -= 1.0;
            }
        }
        for (int i = 0; i < objectArray.length; ++i) {
            Object object2;
            String string3 = (String)objectArray[i];
            object = (String)hashMap.get(string3);
            JarEntry jarEntry = jarFile.getJarEntry((String)object);
            if (jarEntry == null) {
                object2 = "move" + (String)object + " " + string3;
                this.handleException("jardiff.error.badmove", (String)object2);
            }
            object2 = new JarEntry(string3);
            ((ZipEntry)object2).setTime(jarEntry.getTime());
            ((ZipEntry)object2).setSize(jarEntry.getSize());
            ((ZipEntry)object2).setCompressedSize(jarEntry.getCompressedSize());
            ((ZipEntry)object2).setCrc(jarEntry.getCrc());
            ((ZipEntry)object2).setMethod(jarEntry.getMethod());
            ((ZipEntry)object2).setExtra(jarEntry.getExtra());
            ((ZipEntry)object2).setComment(jarEntry.getComment());
            this.updateDelegate(patchDelegate, d2, d);
            d2 += 1.0;
            this.writeEntry(jarOutputStream, (JarEntry)object2, jarFile.getInputStream(jarEntry));
            boolean bl = hashSet2.remove(object);
            if (!bl) continue;
            d -= 1.0;
        }
        Iterator iterator = hashSet2.iterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                object = jarFile.getJarEntry(string4);
                this.updateDelegate(patchDelegate, d2, d);
                d2 += 1.0;
                this.writeEntry(jarOutputStream, (JarEntry)object, jarFile);
            }
        }
        this.updateDelegate(patchDelegate, d2, d);
        jarOutputStream.finish();
        jarOutputStream.close();
        jarFile.close();
        jarFile2.close();
    }

    private void updateDelegate(Patcher.PatchDelegate patchDelegate, double d, double d2) throws CancelException {
        if (patchDelegate != null) {
            patchDelegate.patching((int)(100.0 * d / d2));
        }
    }

    private void determineNameMapping(JarFile jarFile, Set set, Map map) throws IOException {
        LineNumberReader lineNumberReader;
        String string;
        InputStream inputStream = jarFile.getInputStream(jarFile.getEntry("META-INF/INDEX.JD"));
        if (inputStream == null) {
            this.handleException("jardiff.error.noindex", null);
        }
        if ((string = (lineNumberReader = new LineNumberReader(new InputStreamReader(inputStream, "UTF-8"))).readLine()) == null || !string.equals("version 1.0")) {
            this.handleException("jardiff.error.badheader", string);
        }
        while ((string = lineNumberReader.readLine()) != null) {
            List list;
            if (string.startsWith("remove")) {
                list = this.getSubpaths(string.substring("remove".length()));
                if (list.size() != 1) {
                    this.handleException("jardiff.error.badremove", string);
                }
                set.add(list.get(0));
                continue;
            }
            if (string.startsWith("move")) {
                list = this.getSubpaths(string.substring("move".length()));
                if (list.size() != 2) {
                    this.handleException("jardiff.error.badmove", string);
                }
                if (map.put(list.get(1), list.get(0)) == null) continue;
                this.handleException("jardiff.error.badmove", string);
                continue;
            }
            if (string.length() <= 0) continue;
            this.handleException("jardiff.error.badcommand", string);
        }
        lineNumberReader.close();
        inputStream.close();
    }

    private void handleException(String string, String string2) throws IOException {
        try {
            throw new IOException(ResourceManager.getString(string, string2));
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("Fatal error: " + string);
            new Throwable().printStackTrace(System.err);
            System.exit(-1);
            return;
        }
    }

    private List getSubpaths(String string) {
        int n = 0;
        int n2 = string.length();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (n < n2) {
            int n3;
            while (n < n2 && Character.isWhitespace(string.charAt(n))) {
                ++n;
            }
            if (n >= n2) continue;
            int n4 = n3 = n;
            String string2 = null;
            while (n < n2) {
                char c = string.charAt(n);
                if (c == '\\' && n + 1 < n2 && string.charAt(n + 1) == ' ') {
                    string2 = string2 == null ? string.substring(n4, n) : string2 + string.substring(n4, n);
                    n4 = ++n;
                } else if (Character.isWhitespace(c)) break;
                ++n;
            }
            if (n4 != n) {
                string2 = string2 == null ? string.substring(n4, n) : string2 + string.substring(n4, n);
            }
            arrayList.add(string2);
        }
        return arrayList;
    }

    private void writeEntry(JarOutputStream jarOutputStream, JarEntry jarEntry, JarFile jarFile) throws IOException {
        this.writeEntry(jarOutputStream, jarEntry, jarFile.getInputStream(jarEntry));
    }

    private void writeEntry(JarOutputStream jarOutputStream, JarEntry jarEntry, InputStream inputStream) throws IOException {
        jarOutputStream.putNextEntry(new ZipEntry(jarEntry.getName()));
        int n = inputStream.read(this.newBytes);
        while (n != -1) {
            jarOutputStream.write(this.newBytes, 0, n);
            n = inputStream.read(this.newBytes);
        }
        inputStream.close();
    }
}

